// $Id$
// From Philippe Le Hegaret (Philippe.Le_Hegaret@sophia.inria.fr)
// Rewritten 2010 Yves Lafon <ylafon@w3.org>

// (c) COPYRIGHT MIT, ERCIM and Keio, 1997-2010.
// Please first read the full copyright statement in file COPYRIGHT.html
package org.w3c.css.properties.css;

import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

/**
 * @since CSS1
 */
public class CssBackground extends CssProperty {

    public CssValue value;

    public CssBackgroundColor color;
    public CssBackgroundImage image;
    public CssBackgroundRepeat repeat;
    public CssBackgroundAttachment attachment;
    public CssBackgroundPosition position;
    public CssBackgroundSize size;

    public boolean same;

    /**
     * Create a new CssBackground
     */
    public CssBackground() {
    }

    /**
     * Set the value of the property<br/>
     * Does not check the number of values
     *
     * @param expression The expression for this property
     * @throws InvalidParamException The expression is incorrect
     */
    public CssBackground(ApplContext ac, CssExpression expression)
            throws InvalidParamException {
        this(ac, expression, false);
    }

    /**
     * Set the value of the property
     *
     * @param expression The expression for this property
     * @param check      set it to true to check the number of values
     * @throws InvalidParamException The expression is incorrect
     */
    public CssBackground(ApplContext ac, CssExpression expression,
                         boolean check) throws InvalidParamException {
        throw new InvalidParamException("unrecognize", ac);

    }



    /**
     * Returns the value of this property
     */
    public Object get() {
        return value;
    }

    /**
     * Returns the color
     */
    public CssValue getColor() {
        if (color == null) {
            return null;
        } else {
            return color.getColor();
        }
    }

    /**
     * Returns the name of this property
     */
    public final String getPropertyName() {
        return "background";
    }

    /**
     * Returns a string representation of the object.
     */
    public String toString() {
        return value.toString();
    }

	/**
	 * Add this property to the CssStyle
	 *
	 * @param style The CssStyle
	 */
	public void addToStyle(ApplContext ac, CssStyle style) {
		((Css1Style) style).cssBackground.same = same;
		((Css1Style) style).cssBackground.byUser = byUser;

		if (color != null) {
			color.addToStyle(ac, style);
		}
		if (image != null) {
			image.addToStyle(ac, style);
		}
		if (repeat != null) {
			repeat.addToStyle(ac, style);
		}
		if (attachment != null) {
			attachment.addToStyle(ac, style);
		}
		if (position != null) {
			position.addToStyle(ac, style);
		}
		if (size != null) {
			size.addToStyle(ac, style);
		}
	}

	/**
	 * Set this property to be important.
	 * Overrides this method for a macro
	 */
	public void setImportant() {
		super.setImportant();
		if (color != null) {
			color.important = true;
		}
		if (image != null) {
			image.important = true;
		}
		if (repeat != null) {
			repeat.important = true;
		}
		if (attachment != null) {
			attachment.important = true;
		}
		if (position != null) {
			position.important = true;
		}
		if (size != null) {
			size.important = true;
		}
	}

	/**
	 * Set the context.
	 * Overrides this method for a macro
	 *
	 * @see org.w3c.css.css.CssCascadingOrder#order
	 * @see org.w3c.css.css.StyleSheetParser#handleRule
	 */
	public void setSelectors(CssSelectors selector) {
		super.setSelectors(selector);
		if (color != null) {
			color.setSelectors(selector);
		}
		if (image != null) {
			image.setSelectors(selector);
		}
		if (repeat != null) {
			repeat.setSelectors(selector);
		}
		if (attachment != null) {
			attachment.setSelectors(selector);
		}
		if (position != null) {
			position.setSelectors(selector);
		}
		if (size != null) {
			size.setSelectors(selector);
		}
	}

	/**
	 * Update the source file and the line.
	 * Overrides this method for a macro
	 *
	 * @param line   The line number where this property is defined
	 * @param source The source file where this property is defined
	 */
	public void setInfo(int line, String source) {
		super.setInfo(line, source);
		if (color != null) {
			color.setInfo(line, source);
		}
		if (image != null) {
			image.setInfo(line, source);
		}
		if (repeat != null) {
			repeat.setInfo(line, source);
		}
		if (attachment != null) {
			attachment.setInfo(line, source);
		}
		if (position != null) {
			position.setInfo(line, source);
		}
		if (size != null) {
			size.setInfo(line, source);
		}
	}

    /**
     * Get this property in the style.
     *
     * @param style   The style where the property is
     * @param resolve if true, resolve the style to find this property
     */
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style) style).getBackground();
        } else {
            return ((Css1Style) style).cssBackground;
        }
    }

    /**
     * Compares two properties for equality.
     *
     * @param property The other property.
     */
    public boolean equals(CssProperty property) {
        return false; // FIXME
    }
}
